local assets=
{
	Asset("ANIM", "anim/scroll.zip"),
	Asset("IMAGE", "images/inventoryimages/scroll.tex"),
	Asset("ATLAS", "images/inventoryimages/scroll.xml"),
}

local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
    MakeInventoryPhysics(inst)
    	
    inst.AnimState:SetBank("scroll")
    inst.AnimState:SetBuild("scroll")
    inst.AnimState:PlayAnimation("idle", false)
    	
    inst:AddComponent("inspectable")
	
	
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = 40
		
	inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.SMALL_FUEL
	
	MakeSmallBurnable(inst, TUNING.SMALL_BURNTIME)
    MakeSmallPropagator(inst)

	inst:AddComponent("inventoryitem")
	 inst.components.inventoryitem.atlasname = "images/inventoryimages/scroll.xml"
	
    return inst
end

return Prefab( "common/inventory/scroll", fnab, assets) 